<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
?>
<div class="dllfh-song-list">
    <?php if ( ! empty( $songs ) ): ?>
        <?php foreach ( $songs as $song ):
            $artist = !empty($song['artist']['name']) ? $song['artist']['name'] : 'Unbekannter Interpret';
            $title = !empty($song['title']) ? $song['title'] : 'Unbekannter Titel';
            $img_url = $cover_finder->get_cover_url( $artist, $title );
            $startedAt = !empty($song['started_at']) ? date( 'H:i', strtotime( $song['started_at'] ) ) : '';
            $search_query = urlencode( "{$artist} - {$title}" );
        ?>
              <div class="dllfh-song-entry">
                  <div class="dllfh-song-cover">
                      <img src="<?= esc_url( $img_url ) ?>" alt="<?= esc_attr( "{$artist} - {$title}" ) ?>">
                  </div>
                  <div class="dllfh-song-details">
                      <div class="dllfh-time-title">
                          <?= esc_html( $startedAt ) ?>: <strong><?= esc_html( $title ) ?></strong>
                      </div>
                      <div class="dllfh-artist">
                          von <b><?= esc_html( $artist ) ?></b>
                      </div>
                      <div class="dllfh-service-links">
                          <?php if (!empty($settings['show_icons']['youtube'])): ?><a href='https://www.youtube.com/results?search_query=<?= $search_query ?>' target='_blank' rel='noopener noreferrer'><img src='<?= esc_url( plugins_url( '../img/youtube.png', __FILE__ ) ) ?>' alt="YouTube"></a><?php endif; ?>
                          <?php if (!empty($settings['show_icons']['soundcloud'])): ?><a href='https://soundcloud.com/search?q=<?= $search_query ?>' target='_blank' rel='noopener noreferrer'><img src='<?= esc_url( plugins_url( '../img/soundcloud.png', __FILE__ ) ) ?>' alt="SoundCloud"></a><?php endif; ?>
                          <?php if (!empty($settings['show_icons']['spotify'])): ?><a href='https://open.spotify.com/search/<?= $search_query ?>' target='_blank' rel='noopener noreferrer'><img src='<?= esc_url( plugins_url( '../img/spotify.png', __FILE__ ) ) ?>' alt="Spotify"></a><?php endif; ?>
                          <?php if (!empty($settings['show_icons']['amazon'])): ?><a href='https://music.amazon.de/search/<?= $search_query ?>' target='_blank' rel='noopener noreferrer'><img src='<?= esc_url( plugins_url( '../img/amazon.png', __FILE__ ) ) ?>' alt="Amazon Music"></a><?php endif; ?>
                          <?php if (!empty($settings['show_icons']['itunes'])): ?><a href='https://music.apple.com/us/search?term=<?= $search_query ?>' target='_blank' rel='noopener noreferrer'><img src='<?= esc_url( plugins_url( '../img/itunes.png', __FILE__ ) ) ?>' alt="Apple Music"></a><?php endif; ?>
                      </div>
                  </div>
              </div>
        <?php endforeach; ?>
    <?php else: ?>
        <p>Keine Song-History für diesen Stream verfügbar.</p>
    <?php endif; ?>
</div>