jQuery(document).ready(function($) {
    // Finde jeden History-Wrapper auf der Seite
    $('.dllfh-wrapper[data-stream]').each(function() {
        var wrapper = $(this);
        var wrapperId = wrapper.attr('id'); // Die eindeutige ID des Wrappers
        var streamName = wrapper.data('stream'); // Den Stream-Namen aus data-stream lesen
        var songCount = wrapper.data('count');   // Die Anzahl aus data-count lesen

        // Starte das Intervall für diesen spezifischen Wrapper
        var refreshInterval = setInterval(function() {
            // Sicherheitshalber: Wenn das Element nicht mehr auf der Seite ist, stoppe das Intervall
            if ($('#' + wrapperId).length === 0) {
                clearInterval(refreshInterval);
                return;
            }

            // Die Daten, die wir an den Server senden
            var data = {
                action: 'dllfh_refresh_history', // Unsere registrierte PHP-Action
                nonce: dllfh_ajax.nonce,         // Das Sicherheitstoken
                stream: streamName,
                count: songCount
            };

            // Der AJAX-POST-Request an die von PHP übergebene URL
            $.post(dllfh_ajax.ajax_url, data, function(response) {
                // Prüfe, ob die Antwort erfolgreich war und Daten enthält
                if (response.success && response.data) {
                    // Ersetze den Inhalt des .dllfh-song-list Containers mit dem neuen HTML
                    $('#' + wrapperId).find('.dllfh-song-list').html(response.data);
                }
            });

        }, 60000); // 30000 Millisekunden = 30 Sekunden (60 Sekunden ist auch super)
    });
});