<?php
class DeeLauLab_LautFM_Controller {

    private static $styles_printed = false;

    public function __construct() {
        add_shortcode( 'lautfm_history', [ $this, 'handle_shortcode' ] );
        add_action( 'wp_ajax_dllfh_refresh_history', [ $this, 'ajax_refresh_history' ] );
        add_action( 'wp_ajax_nopriv_dllfh_refresh_history', [ $this, 'ajax_refresh_history' ] );
    }

    private function _get_history_html($stream, $count) {
        $settings = wp_parse_args( get_option('deelaulab_lfh_settings', []), $this->get_default_settings() );
        $model = new DeeLauLab_LautFM_Model();
        $song_data = $model->get_last_songs($stream);

        if (is_wp_error($song_data)) {
            return (new DeeLauLab_LautFM_View())->render_error( $song_data->get_error_message() );
        }
        
        if (empty($song_data)) {
            return '<p>Keine Song-History für diesen Stream verfügbar.</p>';
        }

        try {
            $cover_finder = new DeeLauLab_Cover_Finder($settings);
            $view_data = [
                'songs'        => array_slice( $song_data, 0, $count ),
                'settings'     => $settings,
                'cover_finder' => $cover_finder
            ];
            
            return ( new DeeLauLab_LautFM_View() )->render( 'history-display-v2', $view_data );

        } catch (Throwable $e) {
            $error_message  = "Ein fataler PHP-Fehler ist aufgetreten und hat die Anzeige verhindert.\n";
            $error_message .= "Fehlermeldung: " . $e->getMessage();
            return '<pre class="dllfh-error-message">' . esc_html($error_message) . '</pre>';
        }
    }
    
    public function handle_shortcode( $atts ) {
        wp_enqueue_style('deelaulab-lautfm-history-style', plugin_dir_url( dirname( __FILE__ ) ) . 'assets/css/style.css', [], '2.1.2');
        wp_enqueue_script(
            'deelaulab-lautfm-refresher', 
            plugin_dir_url( dirname( __FILE__ ) ) . 'assets/js/refresher.js', 
            ['jquery'],
            '1.0.0', 
            true
        );

        wp_localize_script(
            'deelaulab-lautfm-refresher',
            'dllfh_ajax',
            [
                'ajax_url' => admin_url( 'admin-ajax.php' ),
                'nonce'    => wp_create_nonce( 'dllfh_ajax_nonce' )
            ]
        );

        $settings = wp_parse_args( get_option('deelaulab_lfh_settings', []), $this->get_default_settings() );
        $atts = shortcode_atts(['stream' => '', 'count' => $settings['history_count']], $atts, 'lautfm_history');

        if ( empty( $atts['stream'] ) ) {
            return (new DeeLauLab_LautFM_View())->render_error('Fehler: Im Shortcode wurde kein Stream-Name angegeben. Beispiel: [lautfm_history stream="dein-stream-name"]');
        }

        $output = '';
        if (!self::$styles_printed) {
            $output .= $this->generate_dynamic_styles($settings);
            self::$styles_printed = true;
        }

        if ( !empty($settings['debug_mode']) && $settings['debug_mode'] === '1' ) {
            $output .= '<pre style="background:#fff; color:#000; border:1px solid #000; padding:15px; margin-bottom:20px; text-align:left;">';
            $output .= '<strong>GELADENE EINSTELLUNGEN:</strong><br><br>';
            $output .= esc_html(print_r($settings, true));
            $output .= '</pre>';
        }
        
        $history_html = $this->_get_history_html($atts['stream'], $atts['count']);

        $wrapper_id = 'dllfh-wrapper-' . uniqid();
        $output .= sprintf(
            '<div id="%s" class="dllfh-wrapper" data-stream="%s" data-count="%d">%s</div>',
            esc_attr($wrapper_id),
            esc_attr($atts['stream']),
            absint($atts['count']),
            $history_html
        );

        return $output;
    }

    public function ajax_refresh_history() {
        check_ajax_referer( 'dllfh_ajax_nonce', 'nonce' );
        $stream = isset($_POST['stream']) ? sanitize_text_field($_POST['stream']) : '';
        $count = isset($_POST['count']) ? absint($_POST['count']) : 10;

        if ( empty($stream) ) {
            wp_send_json_error( 'Kein Stream angegeben.' );
        }

        $new_html = $this->_get_history_html($stream, $count);
        
        wp_send_json_success( $new_html );
    }
    
    public function get_default_settings() { return [ 'spotify_client_id' => '', 'spotify_client_secret' => '', 'lastfm_api_key' => '', 'fallback_cover_url' => '', 'bg_color_main' => '', 'bg_color_song' => '', 'color_title' => '', 'color_artist' => '', 'color_time' => '', 'cover_size' => 80, 'history_count' => 10, 'show_icons' => ['youtube' => '1', 'soundcloud' => '1', 'spotify' => '1', 'amazon' => '1', 'itunes' => '1'], 'debug_mode' => '0' ]; }
    public function generate_dynamic_styles($settings) { $css = '<style>'; $add_rule = function($selector, $property, $value) use (&$css) { if (!empty($value)) { $css .= sprintf('%s { %s: %s !important; }', $selector, $property, esc_attr($value)); } }; $add_rule('.dllfh-wrapper', 'background-color', $settings['bg_color_main']); $add_rule('.dllfh-song-entry', 'background-color', $settings['bg_color_song']); $add_rule('.dllfh-song-details .dllfh-time-title strong', 'color', $settings['color_title']); $add_rule('.dllfh-song-details .dllfh-artist', 'color', $settings['color_artist']); $add_rule('.dllfh-song-details .dllfh-time-title', 'color', $settings['color_time']); $add_rule('.dllfh-song-cover', 'width', $settings['cover_size'] . 'px'); $css .= '</style>'; return $css; }
}