<?php
class DeeLauLab_LautFM_Model {
    public function get_last_songs( $streamname ) {
        $transient_key = 'dllfh_history_' . $streamname;
        $cached_songs = get_transient( $transient_key );
        if ( false !== $cached_songs ) { return $cached_songs; }
        $api_url = "https://api.laut.fm/station/{$streamname}/last_songs";
        $response = wp_remote_get( $api_url, [ 'timeout' => 10 ] );
        if ( is_wp_error( $response ) ) { return new WP_Error( 'api_error', 'Die laut.fm API ist derzeit nicht erreichbar.' ); }
        $response_code = wp_remote_retrieve_response_code( $response );
        if ( 200 !== $response_code ) { set_transient( $transient_key, [], 60 ); return new WP_Error( 'invalid_stream', 'Der Stream konnte nicht gefunden werden.' );}
        $songs = json_decode( wp_remote_retrieve_body( $response ), true );
        if ( ! is_array( $songs ) ) { set_transient( $transient_key, [], 60 ); return new WP_Error( 'invalid_data', 'Ungültige Daten von API empfangen.' );}
        set_transient( $transient_key, $songs, 30 );
        return $songs;
    }
}