document.addEventListener('DOMContentLoaded', function() {
    const tickers = document.querySelectorAll('.deelaulab-ticker-wrap');
    const initTickerAnimation = (ticker) => {
        const content = ticker.querySelector('.deelaulab-ticker-content p');
        const scrollingContainer = ticker.querySelector('.deelaulab-ticker-content');
        if (!content || !scrollingContainer) return;
        scrollingContainer.style.animation = 'none';
        const containerWidth = ticker.offsetWidth;
        const contentWidth = content.offsetWidth;
        const speed = parseInt(ticker.getAttribute('data-speed'), 10) || 50;
        if (contentWidth > containerWidth) {
            const distance = contentWidth;
            const duration = distance / speed;
            scrollingContainer.style.setProperty('--animation-duration', duration + 's');
            scrollingContainer.style.animation = '';
        }
    };
    tickers.forEach(initTickerAnimation);
    let resizeTimer;
    window.addEventListener('resize', () => {
        clearTimeout(resizeTimer);
        resizeTimer = setTimeout(() => {
            tickers.forEach(initTickerAnimation);
        }, 250);
    });
});