<?php
/**
 * Plugin Name:       DeeLauLab RSS & News Ticker
 * Description:       Verwaltet und zeigt mehrere anpassbare News Ticker über einen Custom Post Type.
 * Version:           1.1.0
 * Author:            DeeLauLab
 * Author URI:        https://lautbox.eu
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       deelaulab-ticker
 */

if (!defined('ABSPATH')) {exit;}
final class DeeLauLab_Ticker_Main {
    private static $instance;
    public static function instance() {
        if (!isset(self::$instance)) {
            self::$instance = new DeeLauLab_Ticker_Main();
            self::$instance->setup_plugin();
        }
        return self::$instance;
    }
    private function setup_plugin() {
        $this->include_files();
        $this->initialize_classes();
    }
    private function include_files() {
        require_once plugin_dir_path(__FILE__) . 'includes/class-cpt-manager.php';
        require_once plugin_dir_path(__FILE__) . 'includes/class-meta-box-manager.php';
        require_once plugin_dir_path(__FILE__) . 'includes/class-assets-manager.php';
        require_once plugin_dir_path(__FILE__) . 'includes/class-shortcode-manager.php';
        require_once plugin_dir_path(__FILE__) . 'includes/class-dashboard-manager.php';
    }
    private function initialize_classes() {
        new Deelaulab_Ticker_CPT_Manager();
        new Deelaulab_Ticker_Meta_Box_Manager();
        new Deelaulab_Ticker_Assets_Manager();
        new Deelaulab_Ticker_Shortcode_Manager();
        new Deelaulab_Ticker_Dashboard_Manager();
    }
}
function deelaulab_ticker_run() {
    return DeeLauLab_Ticker_Main::instance();
}
deelaulab_ticker_run();