<?php
if ( ! defined( 'ABSPATH' ) ) { exit; }
class Deelaulab_Ticker_Assets_Manager {
    public function __construct() {
        add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_scripts' ) );
        add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_frontend_scripts' ) );
    }
    public function enqueue_admin_scripts( $hook ) {
        global $post;
        if ( ( $hook == 'post-new.php' || $hook == 'post.php' ) && isset($post->post_type) && 'deelaulab_ticker' === $post->post_type ) {
            wp_enqueue_style( 'wp-color-picker' );
            wp_enqueue_script( 'wp-color-picker-alpha', plugin_dir_url( __DIR__ ) . 'assets/js/wp-color-picker-alpha.js', array( 'wp-color-picker' ), '3.0.4', true );
            wp_enqueue_script( 'deelaulab-admin-script', plugin_dir_url( __DIR__ ) . 'assets/js/admin-script.js', array( 'jquery', 'wp-color-picker-alpha' ), '3.5', true );
        }
    }
    public function enqueue_frontend_scripts() {
        wp_enqueue_style( 'deelaulab-styles', plugin_dir_url( __DIR__ ) . 'assets/css/style.css', array(), '3.4' );
        wp_enqueue_script( 'deelaulab-frontend-script', plugin_dir_url( __DIR__ ) . 'assets/js/frontend-script.js', array(), '3.4', true );
    }
}