<?php
if (!defined('ABSPATH')) {exit;}
class Deelaulab_Ticker_CPT_Manager {
    public function __construct() {
        add_action( 'init', array( $this, 'register_cpt' ) );
    }
    public function register_cpt() {
        $labels = array(
            'name'               => _x( 'DLL Ticker', 'post type general name', 'deelaulab-ticker' ),
            'singular_name'      => _x( 'Ticker', 'post type singular name', 'deelaulab-ticker' ),
            'menu_name'          => _x( 'DLL Ticker', 'admin menu', 'deelaulab-ticker' ),
            'name_admin_bar'     => _x( 'DLL Ticker', 'add new on admin bar', 'deelaulab-ticker' ),
            'add_new'            => _x( 'Neuen Ticker erstellen', 'ticker', 'deelaulab-ticker' ),
            'add_new_item'       => __( 'Neuen Ticker erstellen', 'deelaulab-ticker' ),
            'new_item'           => __( 'Neuer Ticker', 'deelaulab-ticker' ),
            'edit_item'          => __( 'Ticker bearbeiten', 'deelaulab-ticker' ),
            'view_item'          => __( 'Ticker ansehen', 'deelaulab-ticker' ),
            'all_items'          => __( 'Alle Ticker', 'deelaulab-ticker' ),
            'search_items'       => __( 'Ticker suchen', 'deelaulab-ticker' ),
            'not_found'          => __( 'Keine Ticker gefunden.', 'deelaulab-ticker' ),
            'not_found_in_trash' => __( 'Keine Ticker im Papierkorb gefunden.', 'deelaulab-ticker' )
        );
        $args = array(
            'labels'             => $labels,
            'public'             => true,
            'publicly_queryable' => true,
            'show_ui'            => true,
            'show_in_menu'       => true,
            'query_var'          => true,
            'rewrite'            => array( 'slug' => 'ticker' ),
            'capability_type'    => 'post',
            'has_archive'        => true,
            'hierarchical'       => false,
            'menu_position'      => 20,
            'menu_icon'          => 'dashicons-pressthis',
            'supports'           => array( 'title' )
        );
        register_post_type( 'deelaulab_ticker', $args );
    }
}