<?php
/**
 * Dashboard_Manager Klasse
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Deelaulab_Ticker_Dashboard_Manager {

    public function __construct() {
        add_action( 'admin_menu', array( $this, 'add_dashboard_page' ) );
        // NEU: Hook mit späterer Priorität, um sicherzustellen, dass die Menüs existieren, bevor wir sie entfernen.
        add_action( 'admin_menu', array( $this, 'remove_default_submenu_items' ), 999 );
    }

    public function add_dashboard_page() {
        add_submenu_page(
            'edit.php?post_type=deelaulab_ticker',
            'Dashboard',
            'Dashboard',
            'manage_options',
            'deelaulab_ticker_dashboard',
            array( $this, 'render_dashboard_html' )
        );
    }

    // NEUE FUNKTION
    public function remove_default_submenu_items() {
        // Entfernt den Link zur "Alle Ticker"-Liste (die bleibt über unseren Button im Dashboard erreichbar)
        remove_submenu_page( 'edit.php?post_type=deelaulab_ticker', 'edit.php?post_type=deelaulab_ticker' );
        // Entfernt den Link "Neuen Ticker erstellen"
        remove_submenu_page( 'edit.php?post_type=deelaulab_ticker', 'post-new.php?post_type=deelaulab_ticker' );
    }

    public function render_dashboard_html() {
        $all_tickers = new WP_Query(array('post_type' => 'deelaulab_ticker', 'posts_per_page' => -1, 'orderby' => 'title', 'order' => 'ASC'));
        $ticker_count = $all_tickers->found_posts;
        require_once plugin_dir_path( __DIR__ ) . 'views/admin/dashboard-view.php';
    }
}