<?php
/**
 * Meta_Box_Manager Klasse
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Deelaulab_Ticker_Meta_Box_Manager {

    public function __construct() {
        add_action( 'add_meta_boxes', array( $this, 'register_meta_box' ) );
        add_action( 'save_post_deelaulab_ticker', array( $this, 'save_meta_data' ) );
        add_action( 'add_meta_boxes', array( $this, 'remove_unwanted_meta_boxes' ), 999 );
    }

    public function register_meta_box() {
        add_meta_box('deelaulab_ticker_settings_box','Ticker Einstellungen',array( $this, 'render_meta_box_html' ),'deelaulab_ticker','normal','high');
    }

    public function render_meta_box_html( $post ) {
        require_once plugin_dir_path( __DIR__ ) . 'views/admin/meta-box-settings-view.php';
    }

    public function save_meta_data( $post_id ) {
        if ( ! isset( $_POST['deelaulab_ticker_nonce'] ) || ! wp_verify_nonce( $_POST['deelaulab_ticker_nonce'], 'deelaulab_save_ticker_settings' ) ) return;
        if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
        if ( ! current_user_can( 'edit_post', $post_id ) ) return;
        function sanitize_rgba_color( $color ) {
            if ( empty( $color ) ) {
                return '';
            }
            if ( preg_match( '/^#([a-f0-9]{3}){1,2}$/i', $color ) ) {
                return $color;
            }
            if ( strpos( strtolower( $color ), 'rgba' ) === 0 ) {
                return trim( strip_tags( $color ) );
            }
            return '';
        }

        $fields = [
            'deelaulab_content_type'      => 'sanitize_text_field',
            'deelaulab_manual_text'       => 'sanitize_textarea_field',
            'deelaulab_rss_url'           => 'esc_url_raw',
            'deelaulab_rss_items'         => 'intval',
            'deelaulab_background_color'  => 'sanitize_rgba_color',
            'deelaulab_text_color'        => 'sanitize_rgba_color',
            'deelaulab_text_color_hover'  => 'sanitize_rgba_color',
            'deelaulab_direction'         => 'sanitize_text_field',
            'deelaulab_font_size'         => 'intval',
            'deelaulab_speed'             => 'intval',
        ];

        foreach ( $fields as $key => $sanitize_callback ) {
            if ( isset( $_POST[$key] ) ) {
                if ( function_exists( $sanitize_callback ) ) {
                    $value = call_user_func( $sanitize_callback, $_POST[$key] );
                    update_post_meta( $post_id, '_' . $key, $value );
                }
            }
        }
    }
    public function remove_unwanted_meta_boxes() {
        // ... (Funktion bleibt unverändert)
        global $wp_meta_boxes; $post_type = 'deelaulab_ticker'; $allowed_box_id = 'deelaulab_ticker_settings_box';
        foreach (['normal', 'advanced', 'side'] as $context) { foreach (['high', 'sorted', 'core', 'default', 'low'] as $priority) {
        if (isset($wp_meta_boxes[$post_type][$context][$priority])) { foreach ($wp_meta_boxes[$post_type][$context][$priority] as $box_id => $box) {
        if ($box_id !== $allowed_box_id && $box_id !== 'submitdiv') { remove_meta_box($box_id, $post_type, $context); }}}}}
    }
}