<?php
/**
 * Shortcode_Manager Klasse
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

class Deelaulab_Ticker_Shortcode_Manager {

    public function __construct() {
        add_shortcode( 'deelaulab_ticker', array( $this, 'render_shortcode' ) );
    }

    public function render_shortcode( $atts ) {
        if ( ! isset( $atts['id'] ) || ! is_numeric( $atts['id'] ) ) { return ""; }
        $post_id = intval( $atts['id'] );
        $opts = get_post_meta( $post_id );
        $content_type = isset($opts['_deelaulab_content_type'][0]) ? $opts['_deelaulab_content_type'][0] : 'manual';
        
        $output_html = ''; 

        if ( 'rss' === $content_type ) {
            // ... (RSS-Logik bleibt unverändert)
            $rss_url = isset($opts['_deelaulab_rss_url'][0]) ? $opts['_deelaulab_rss_url'][0] : ''; $rss_items = isset($opts['_deelaulab_rss_items'][0]) ? intval($opts['_deelaulab_rss_items'][0]) : 5;
            if ( ! empty( $rss_url ) ) { include_once( ABSPATH . WPINC . '/feed.php' ); $feed = fetch_feed( $rss_url );
            if ( ! is_wp_error( $feed ) ) { $maxitems = $feed->get_item_quantity( $rss_items ); $feed_items = $feed->get_items( 0, $maxitems ); $html_links = array();
            foreach ( $feed_items as $item ) { $link_url = esc_url( $item->get_permalink() ); $link_title = esc_html( $item->get_title() ); $html_links[] = '<a href="' . $link_url . '" target="_blank" rel="noopener noreferrer">' . $link_title . '</a>'; }
            $output_html = implode( ' +++ ', $html_links ); } else { $output_html = esc_html('RSS-Feed konnte nicht geladen werden.'); } }
        } else {
            $manual_text = isset($opts['_deelaulab_manual_text'][0]) ? $opts['_deelaulab_manual_text'][0] : 'Kein Text festgelegt.';
            $output_html = esc_html( $manual_text );
        }

        $background_color   = isset($opts['_deelaulab_background_color'][0]) ? $opts['_deelaulab_background_color'][0] : '#1a1a1a';
        $text_color         = isset($opts['_deelaulab_text_color'][0]) ? $opts['_deelaulab_text_color'][0] : '#ffffff';
        $direction          = isset($opts['_deelaulab_direction'][0]) ? $opts['_deelaulab_direction'][0] : 'rtl';
        $text_color_hover   = isset($opts['_deelaulab_text_color_hover'][0]) ? $opts['_deelaulab_text_color_hover'][0] : '#ffffff';
        $font_size          = isset($opts['_deelaulab_font_size'][0]) ? intval($opts['_deelaulab_font_size'][0]) : 16;
        $speed              = isset($opts['_deelaulab_speed'][0]) ? intval($opts['_deelaulab_speed'][0]) : 50;
        
        $ticker_unique_id = 'deelaulab-ticker-' . $post_id;
        
        // --- GEÄNDERT: Style-Block Logik ---
        $dynamic_styles = "
            <style>
                #{$ticker_unique_id}.deelaulab-ticker-wrap {
                    font-size: {$font_size}px;
                }
                /* Hintergrund-Hover wurde entfernt */

                /* Standardfarbe für Text/Links */
                #{$ticker_unique_id}.deelaulab-ticker-wrap p,
                #{$ticker_unique_id}.deelaulab-ticker-wrap a {
                    color: {$text_color} !important;
                    transition: color 0.3s ease;
                }
                /* Hover-Farbe NUR für den jeweiligen Link, über dem die Maus schwebt */
                #{$ticker_unique_id}.deelaulab-ticker-wrap a:hover {
                    color: {$text_color_hover} !important;
                }
            </style>
        ";
        
        ob_start();
        $text = $output_html; 
        require plugin_dir_path( __DIR__ ) . 'views/frontend/ticker-display-view.php';
        return $dynamic_styles . ob_get_clean();
    }
}