<?php
/**
 * View-Datei für das Plugin-Dashboard.
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

// Diese Variablen werden von der Dashboard_Manager-Klasse bereitgestellt:
// $all_tickers, $ticker_count

?>
<style>
    /* Passt die Spaltenbreiten nur auf dieser spezifischen Dashboard-Seite an */
    .columns-2 #postbox-container-1 {
        width: 80% !important;
    }
    .columns-2 #postbox-container-2 {
        width: 20% !important;
    }
</style>

<div class="wrap">
    <h1><?php echo esc_html( get_admin_page_title() ); ?></h1>
    <p>Willkommen beim Dashboard für deine DLL Ticker. Hier findest du eine Übersicht und nützliche Werkzeuge.</p>

    <div id="dashboard-widgets-wrap">
        <div id="dashboard-widgets" class="metabox-holder columns-2">

            <div id="postbox-container-1" class="postbox-container">
                <div class="meta-box-sortables">
                    <div class="postbox">
                        <h2 class="hndle"><span>Shortcode-Helfer</span></h2>
                        <div class="inside">
                            <p>Füge diese Shortcodes in deine Seiten oder Beiträge ein, um den jeweiligen Ticker anzuzeigen.</p>
                            <?php if ( $all_tickers->have_posts() ) : ?>
                                <table class="widefat striped">
                                    <thead>
                                        <tr>
                                            <th>Ticker-Titel</th>
                                            <th>Shortcode</th>
                                            <th>Aktionen</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php while ( $all_tickers->have_posts() ) : $all_tickers->the_post(); ?>
                                            <tr>
                                                <td><strong><?php the_title(); ?></strong></td>
                                                <td>
                                                    <input type="text" value="[deelaulab_ticker id=&quot;<?php the_ID(); ?>&quot;]" readonly="readonly" class="widefat" onfocus="this.select();" />
                                                </td>
                                                <td>
                                                    <a href="<?php echo get_edit_post_link( get_the_ID() ); ?>">Bearbeiten</a> | 
                                                    <a href="<?php echo get_delete_post_link( get_the_ID() ); ?>" onclick="return confirm('Möchtest du diesen Ticker wirklich löschen?')" style="color:#a00;">Löschen</a>
                                                </td>
                                            </tr>
                                        <?php endwhile; ?>
                                        <?php wp_reset_postdata(); ?>
                                    </tbody>
                                </table>
                            <?php else : ?>
                                <p>Du hast noch keine Ticker erstellt. <a href="<?php echo admin_url('post-new.php?post_type=deelaulab_ticker'); ?>">Erstelle jetzt deinen ersten!</a></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <div id="postbox-container-2" class="postbox-container">
                <div class="meta-box-sortables">
                    <div class="postbox">
                        <h2 class="hndle"><span>Übersicht</span></h2>
                        <div class="inside">
                            <p>Du hast insgesamt <strong><?php echo esc_html( $ticker_count ); ?></strong> Ticker erstellt.</p>
                            <a href="<?php echo admin_url('post-new.php?post_type=deelaulab_ticker'); ?>" class="button button-primary">Neuen Ticker erstellen</a>
                            </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>