<?php
/**
 * View-Datei für die Ticker-Einstellungen Meta-Box.
 */
if ( ! defined( 'ABSPATH' ) ) { exit; }

$opts = get_post_meta( $post->ID );

// Werte aus dem Array holen und Standardwerte definieren
$content_type     = isset($opts['_deelaulab_content_type'][0]) ? $opts['_deelaulab_content_type'][0] : 'manual';
$manual_text      = isset($opts['_deelaulab_manual_text'][0]) ? $opts['_deelaulab_manual_text'][0] : '';
$rss_url          = isset($opts['_deelaulab_rss_url'][0]) ? $opts['_deelaulab_rss_url'][0] : '';
$rss_items        = isset($opts['_deelaulab_rss_items'][0]) ? $opts['_deelaulab_rss_items'][0] : 5;
$background_color = isset($opts['_deelaulab_background_color'][0]) ? $opts['_deelaulab_background_color'][0] : '#1a1a1a';
$text_color       = isset($opts['_deelaulab_text_color'][0]) ? $opts['_deelaulab_text_color'][0] : '#ffffff';
$direction        = isset($opts['_deelaulab_direction'][0]) ? $opts['_deelaulab_direction'][0] : 'rtl';
$text_color_hover = isset($opts['_deelaulab_text_color_hover'][0]) ? $opts['_deelaulab_text_color_hover'][0] : '#ffffff';
$font_size        = isset($opts['_deelaulab_font_size'][0]) ? $opts['_deelaulab_font_size'][0] : 16;

// NEU: Geschwindigkeitseinstellung mit Standardwert 50
$speed            = isset($opts['_deelaulab_speed'][0]) ? $opts['_deelaulab_speed'][0] : 50;

wp_nonce_field( 'deelaulab_save_ticker_settings', 'deelaulab_ticker_nonce' );
?>

<table class="form-table">
    <tr valign="top"><th scope="row"><label>Inhaltsquelle</label></th><td><fieldset><label><input type="radio" name="deelaulab_content_type" value="manual" <?php checked( $content_type, 'manual' ); ?> /> Manueller Text</label><br /><label><input type="radio" name="deelaulab_content_type" value="rss" <?php checked( $content_type, 'rss' ); ?> /> RSS-Feed</label></fieldset></td></tr>
    <tbody class="ticker-manual-fields"><tr valign="top"><th scope="row"><label for="deelaulab_manual_text">Ticker-Text</label></th><td><textarea id="deelaulab_manual_text" name="deelaulab_manual_text" class="large-text"><?php echo esc_textarea( $manual_text ); ?></textarea></td></tr></tbody>
    <tbody class="ticker-rss-fields"><tr valign="top"><th scope="row"><label for="deelaulab_rss_url">RSS-Feed-URL</label></th><td><input type="url" id="deelaulab_rss_url" name="deelaulab_rss_url" value="<?php echo esc_url( $rss_url ); ?>" class="regular-text" /></td></tr><tr valign="top"><th scope="row"><label for="deelaulab_rss_items">Anzahl der Beiträge</label></th><td><input type="number" id="deelaulab_rss_items" name="deelaulab_rss_items" value="<?php echo intval( $rss_items ); ?>" min="1" max="20" /></td></tr></tbody>

    <tr valign="top">
        <th scope="row"><label for="deelaulab_background_color">Hintergrundfarbe</label></th>
        <td><input type="text" id="deelaulab_background_color" name="deelaulab_background_color" value="<?php echo esc_attr( $background_color ); ?>" class="deelaulab-color-picker" data-alpha-enabled="true" /></td>
    </tr>
    <tr valign="top">
        <th scope="row"><label for="deelaulab_text_color">Schriftfarbe</label></th>
        <td><input type="text" id="deelaulab_text_color" name="deelaulab_text_color" value="<?php echo esc_attr( $text_color ); ?>" class="deelaulab-color-picker" data-alpha-enabled="true" /></td>
    </tr>
    <tr valign="top">
        <th scope="row"><label for="deelaulab_text_color_hover">Schriftfarbe (Hover)</label></th>
        <td><input type="text" id="deelaulab_text_color_hover" name="deelaulab_text_color_hover" value="<?php echo esc_attr( $text_color_hover ); ?>" class="deelaulab-color-picker" data-alpha-enabled="true" /></td>
    </tr>
    <tr valign="top">
        <th scope="row"><label for="deelaulab_font_size">Schriftgröße (in px)</label></th>
        <td><input type="number" id="deelaulab_font_size" name="deelaulab_font_size" value="<?php echo intval( $font_size ); ?>" min="8" max="72" /></td>
    </tr>
    <tr valign="top">
        <th scope="row"><label for="deelaulab_speed">Geschwindigkeit (Pixel pro Sekunde)</label></th>
        <td>
            <input type="number" id="deelaulab_speed" name="deelaulab_speed" value="<?php echo intval( $speed ); ?>" min="10" max="500" />
            <p class="description">Ein guter Startwert ist 50. Höhere Werte bedeuten eine schnellere Laufschrift.</p>
        </td>
    </tr>
    <tr valign="top">
        <th scope="row"><label for="deelaulab_direction">Laufrichtung</label></th>
        <td>
            <select id="deelaulab_direction" name="deelaulab_direction">
                <option value="rtl" <?php selected( $direction, 'rtl' ); ?>>Rechts nach Links</option>
                <option value="ltr" <?php selected( $direction, 'ltr' ); ?>>Links nach Rechts</option>
            </select>
        </td>
    </tr>
</table>