<?php
/**
 * Plugin Name:       DeeLauLab Wunschbox
 * Description:       Eine Wunschbox für Webradios, mit der Hörer Wünsche einreichen und Moderatoren diese verwalten können.
 * Version:           2.0.0
 * Author:            DeeLauLab
 * Author URI:        https://lautbox.eu
 * License:           GPL v2 or later
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       deelaulab-wunschbox
 * Domain Path:       /languages
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'DLLW_VERSION', '2.0.0' );
define( 'DLLW_PLUGIN_PATH', plugin_dir_path( __FILE__ ) );

final class DeeLauLab_Wunschbox {

    private static $instance = null;

    public static function instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        $this->load_dependencies();
        add_action( 'plugins_loaded', [ $this, 'init_plugin' ] );
    }

    private function load_dependencies() {
        require_once DLLW_PLUGIN_PATH . 'includes/class-dllw-setup.php';
        require_once DLLW_PLUGIN_PATH . 'includes/class-dllw-admin.php';
        require_once DLLW_PLUGIN_PATH . 'includes/class-dllw-frontend.php';
    }

    public function init_plugin() {
        DLLW_Setup::get_instance();
        DLLW_Admin::get_instance();
        DLLW_Frontend::get_instance();
    }
}

DeeLauLab_Wunschbox::instance();

register_activation_hook( __FILE__, [ 'DLLW_Setup', 'activate' ] );
/*
function dllw_add_plugin_info_link( $links ) {
  $info_link = '<a href="https://deine-webseite.de/wunschbox-anleitung" target="_blank">Info & Hilfe</a>';
  array_unshift( $links, $info_link );
  return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'dllw_add_plugin_info_link' );
*/

function dllw_run_migration() {
    if ( get_option( 'dllw_migration_v2_done' ) ) {
        return;
    }

    global $wpdb;
    $wpdb->update(
        $wpdb->posts,
        [ 'post_type' => 'dllw_wunsch' ],
        [ 'post_type' => 'lwb_wunsch' ]
    );
    $wpdb->update(
        $wpdb->postmeta,
        [ 'meta_key' => '_dllw_sender_name' ],
        [ 'meta_key' => '_lwb_sender_name' ]
    );
    $old_token = get_option( 'lwb_widget_token' );
    if ( $old_token ) {
        update_option( 'dllw_widget_token', $old_token );
        delete_option( 'lwb_widget_token' );
    }
    update_option( 'dllw_migration_v2_done', true );
}
add_action( 'admin_init', 'dllw_run_migration' );