<?php
/**
 * Klasse für den Admin-Bereich der Wunschbox.
 */
class DLLW_Admin {

    private static $instance = null;

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'admin_menu', [ $this, 'add_admin_menu_page' ] );
        add_action( 'admin_init', [ $this, 'handle_admin_actions' ] );
    }

    public function add_admin_menu_page() {
        add_menu_page(
            __( 'Wunschbox Dashboard', 'deelaulab-wunschbox' ),
            __( 'DLL Wunschbox', 'deelaulab-wunschbox' ),
            'edit_posts',
            'dllw_dashboard',
            [ $this, 'render_dashboard_page' ],
            'dashicons-format-audio',
            3
        );
        
        add_submenu_page(
            'dllw_dashboard',
            __( 'Einstellungen', 'deelaulab-wunschbox' ),
            __( 'Einstellungen', 'deelaulab-wunschbox' ),
            'manage_options',
            'dllw_settings',
            [ $this, 'render_settings_page' ]
        );
    }

    public function handle_admin_actions() {
        if ( isset( $_POST['dllw_regenerate_token'] ) ) {
            if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'dllw_regenerate_token_nonce' ) ) {
                if ( current_user_can( 'manage_options' ) ) {
                    update_option( 'dllw_widget_token', wp_generate_password( 32, false ) );
                    wp_safe_redirect( add_query_arg( 'token_regenerated', '1', admin_url( 'admin.php?page=dllw_settings' ) ) );
                    exit;
                }
            }
        }

        if ( isset( $_POST['dllw_delete_all_played'] ) ) {
            check_admin_referer( 'dllw_delete_all_gespielt_nonce' );
            if ( current_user_can( 'manage_options' ) ) {
                $gespielte_wuensche_ids = get_posts([
                    'post_type'   => 'dllw_wunsch',
                    'post_status' => 'gespielt',
                    'numberposts' => -1,
                    'fields'      => 'ids',
                ]);
                $deleted_count = 0;
                if ( ! empty( $gespielte_wuensche_ids ) ) {
                    foreach ( $gespielte_wuensche_ids as $wunsch_id ) {
                        wp_delete_post( $wunsch_id, true );
                    }
                    $deleted_count = count( $gespielte_wuensche_ids );
                }
                wp_safe_redirect( add_query_arg( 'deleted_count', $deleted_count, admin_url( 'admin.php?page=dllw_dashboard' ) ) );
                exit;
            }
        }

        if ( ! isset( $_GET['action'] ) || ! isset( $_GET['wunsch_id'] ) ) {
            return;
        }
        $action    = sanitize_key( $_GET['action'] );
        $wunsch_id = intval( $_GET['wunsch_id'] );
        $nonce     = isset( $_GET['_wpnonce'] ) ? $_GET['_wpnonce'] : null;

        if ( ! wp_verify_nonce( $nonce, 'dllw_wunsch_action_' . $wunsch_id ) ) {
            wp_die( 'Sicherheitsüberprüfung fehlgeschlagen.' );
        }

        switch ( $action ) {
            case 'set_status_gesucht':
                wp_update_post( [ 'ID' => $wunsch_id, 'post_status' => 'wird_gesucht' ] );
                break;
            case 'set_status_gespielt':
                wp_update_post( [ 'ID' => $wunsch_id, 'post_status' => 'gespielt' ] );
                break;
            case 'trash':
                wp_trash_post( $wunsch_id );
                break;
        }

        wp_safe_redirect( admin_url( 'admin.php?page=dllw_dashboard' ) );
        exit;
    }
    
    public function render_dashboard_page() {
        $wartende_wuensche = get_posts([
            'post_type'   => 'dllw_wunsch',
            'post_status' => ['wartend', 'wird_gesucht'],
            'numberposts' => -1,
            'orderby'     => 'date',
            'order'       => 'ASC',
        ]);
        
        $gespielte_wuensche = get_posts([
            'post_type'   => 'dllw_wunsch',
            'post_status' => 'gespielt',
            'numberposts' => 50,
            'orderby'     => 'modified',
            'order'       => 'DESC',
        ]);

        include_once DLLW_PLUGIN_PATH . 'views/admin-dashboard.php';
    }

    public function render_settings_page() {
        if ( isset( $_GET['token_regenerated'] ) && '1' === $_GET['token_regenerated'] ) {
            echo '<div class="notice notice-success is-dismissible"><p>' . __( 'Neuer Sicherheitstoken wurde erfolgreich generiert!', 'deelaulab-wunschbox' ) . '</p></div>';
        }

        $token = get_option( 'dllw_widget_token' );
        $widget_url = home_url( '/?deelaulab_widget=true&token=' . $token );
        ?>
        <div class="wrap">
            <h1><?php _e( 'Wunschbox Einstellungen', 'deelaulab-wunschbox' ); ?></h1>
            <hr class="wp-header-end">
            
            <h2 style="margin-top: 20px;"><?php _e( 'URL für externes Widget', 'deelaulab-wunschbox' ); ?></h2>
            <p><?php _e( 'Diese URL kannst du in externe Programme wie mAirList oder RadioBOSS einbinden. Behandle sie wie ein Passwort!', 'deelaulab-wunschbox' ); ?></p>
            <input type="text" value="<?php echo esc_url( $widget_url ); ?>" readonly style="width: 100%; padding: 8px;">

            <h2 style="margin-top: 40px;"><?php _e( 'Sicherheitstoken', 'deelaulab-wunschbox' ); ?></h2>
            <p><?php _e( 'Wenn du vermutest, dass deine Widget-URL kompromittiert wurde, kannst du hier einen neuen, zufälligen Token erstellen. Achtung: Die alte URL wird dadurch sofort ungültig!', 'deelaulab-wunschbox' ); ?></p>
            <form method="post" action="">
                <?php wp_nonce_field( 'dllw_regenerate_token_nonce' ); ?>
                <button type="submit" name="dllw_regenerate_token" class="button button-primary"><?php _e( 'Neuen Token generieren', 'deelaulab-wunschbox' ); ?></button>
            </form>
        </div>
        <?php
    }
}