<?php
/**
 * Klasse für das grundlegende Setup (Post Type, Status).
 */
class DLLW_Setup {

    private static $instance = null;

    public static function get_instance() {
        if ( is_null( self::$instance ) ) {
            self::$instance = new self();
        }
        return self::$instance;
    }

    private function __construct() {
        add_action( 'init', [ $this, 'register_post_type_and_statuses' ] );
    }

    public function register_post_type_and_statuses() {
        $labels = [
            'name'          => _x( 'Wünsche', 'Post Type General Name', 'deelaulab-wunschbox' ),
            'singular_name' => _x( 'Wunsch', 'Post Type Singular Name', 'deelaulab-wunschbox' ),
            'menu_name'     => __( 'DLL Wunschbox', 'deelaulab-wunschbox' ),
            'all_items'     => __( 'Alle Wünsche', 'deelaulab-wunschbox' ),
            'add_new_item'  => __( 'Neuen Wunsch erstellen', 'deelaulab-wunschbox' ),
            'add_new'       => __( 'Erstellen', 'deelaulab-wunschbox' ),
        ];
        
        $args = [
            'label'               => __( 'Wunsch', 'deelaulab-wunschbox' ),
            'labels'              => $labels,
            'supports'            => [ 'title', 'editor' ],
            'public'              => false,
            'show_ui'             => true,
            'show_in_menu'        => false,
            'can_export'          => true,
            'exclude_from_search' => true,
            'publicly_queryable'  => false,
            'capability_type'     => 'post',
            'rewrite'             => false,
        ];
        
        register_post_type( 'dllw_wunsch', $args );

        register_post_status( 'wartend', [
            'label'                     => _x( 'Wartend', 'post status', 'deelaulab-wunschbox' ),
            'public'                    => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop( 'Wartend <span class="count">(%s)</span>', 'Wartend <span class="count">(%s)</span>', 'deelaulab-wunschbox' ),
        ]);
        
        register_post_status( 'wird_gesucht', [
            'label'                     => _x( 'Wird gesucht', 'post status', 'deelaulab-wunschbox' ),
            'public'                    => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop( 'Wird gesucht <span class="count">(%s)</span>', 'Wird gesucht <span class="count">(%s)</span>', 'deelaulab-wunschbox' ),
        ]);
        
        register_post_status( 'gespielt', [
            'label'                     => _x( 'Gespielt', 'post status', 'deelaulab-wunschbox' ),
            'public'                    => false,
            'show_in_admin_all_list'    => true,
            'show_in_admin_status_list' => true,
            'label_count'               => _n_noop( 'Gespielt <span class="count">(%s)</span>', 'Gespielt <span class="count">(%s)</span>', 'deelaulab-wunschbox' ),
        ]);
    }
    
    public static function activate() {
        if ( ! get_option( 'dllw_widget_token' ) ) {
            update_option( 'dllw_widget_token', wp_generate_password( 32, false ) );
        }
        $admin_role = get_role( 'administrator' );
        if ( $admin_role ) {
            $admin_role->add_cap( 'manage_wishes', true );
        }
    }
}