<div class="wrap">
    <h1><?php _e( 'Wunschbox Dashboard', 'deelaulab-wunschbox' ); ?></h1>
    
    <?php if ( isset( $_GET['deleted_count'] ) ) : ?>
        <div class="notice notice-success is-dismissible">
            <p><?php echo sprintf( _n( '%s Wunsch wurde endgültig gelöscht.', '%s Wünsche wurden endgültig gelöscht.', intval( $_GET['deleted_count'] ), 'deelaulab-wunschbox' ), intval( $_GET['deleted_count'] ) ); ?></p>
        </div>
    <?php endif; ?>

    <h2><?php _e( 'Aktive Wünsche', 'deelaulab-wunschbox' ); ?></h2>
    <table class="wp-list-table widefat fixed striped">
        <thead>
            <tr>
                <th style="width:15%;"><?php _e( 'Von', 'deelaulab-wunschbox' ); ?></th>
                <th style="width:40%;"><?php _e( 'Wunsch / Gruss', 'deelaulab-wunschbox' ); ?></th>
                <th style="width:15%;"><?php _e( 'Status', 'deelaulab-wunschbox' ); ?></th>
                <th><?php _e( 'Aktionen', 'deelaulab-wunschbox' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( ! empty( $wartende_wuensche ) ) : ?>
                <?php foreach ( $wartende_wuensche as $wunsch ) : ?>
                    <?php
                        $nonce = wp_create_nonce( 'dllw_wunsch_action_' . $wunsch->ID );
                        $url_gesucht = add_query_arg( ['action' => 'set_status_gesucht', 'wunsch_id' => $wunsch->ID, '_wpnonce' => $nonce], admin_url( 'admin.php?page=dllw_dashboard' ) );
                        $url_gespielt = add_query_arg( ['action' => 'set_status_gespielt', 'wunsch_id' => $wunsch->ID, '_wpnonce' => $nonce], admin_url( 'admin.php?page=dllw_dashboard' ) );
                        $url_trash = add_query_arg( ['action' => 'trash', 'wunsch_id' => $wunsch->ID, '_wpnonce' => $nonce], admin_url( 'admin.php?page=dllw_dashboard' ) );
                    ?>
                    <tr>
                        <td><strong><?php echo esc_html( get_post_meta( $wunsch->ID, '_dllw_sender_name', true ) ); ?></strong></td>
                        <td>
                            <strong><?php echo esc_html( $wunsch->post_title ); ?></strong>
                            <p><?php echo nl2br( esc_html( $wunsch->post_content ) ); ?></p>
                        </td>
                        <td><?php echo esc_html( get_post_status_object( $wunsch->post_status )->label ); ?></td>
                        <td>
                            <?php if ( $wunsch->post_status === 'wartend' ) : ?>
                                <a href="<?php echo esc_url( $url_gesucht ); ?>"><?php _e( 'Wird gesucht', 'deelaulab-wunschbox' ); ?></a> |
                            <?php endif; ?>
                            <a href="<?php echo esc_url( $url_gespielt ); ?>"><?php _e( 'Gespielt', 'deelaulab-wunschbox' ); ?></a> | 
                            <a href="<?php echo esc_url( $url_trash ); ?>" style="color:#d63638;"><?php _e( 'Löschen', 'deelaulab-wunschbox' ); ?></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr>
                    <td colspan="4"><?php _e( 'Aktuell liegen keine Wünsche vor.', 'deelaulab-wunschbox' ); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
    
    <br>

    <h2><?php _e( 'Zuletzt gespielt (Letzte 50)', 'deelaulab-wunschbox' ); ?></h2>

    <?php if ( current_user_can( 'manage_options' ) && ! empty( $gespielte_wuensche ) ) : ?>
        <form method="post" action="">
            <?php wp_nonce_field( 'dllw_delete_all_gespielt_nonce' ); ?>
            <button type="submit" name="dllw_delete_all_played" class="button button-danger" onclick="return confirm('<?php _e( 'Sicher ALLE gespielten Wünsche endgültig löschen?', 'deelaulab-wunschbox' ); ?>');">
                <?php _e( 'Alle gespielten Wünsche endgültig löschen', 'deelaulab-wunschbox' ); ?>
            </button>
        </form>
    <?php endif; ?>

    <table class="wp-list-table widefat fixed striped" style="margin-top: 1em;">
        <thead>
            <tr>
                <th style="width:20%;"><?php _e( 'Gespielt am', 'deelaulab-wunschbox' ); ?></th>
                <th style="width:20%;"><?php _e( 'Von', 'deelaulab-wunschbox' ); ?></th>
                <th><?php _e( 'Wunsch / Gruss', 'deelaulab-wunschbox' ); ?></th>
            </tr>
        </thead>
        <tbody>
            <?php if ( ! empty( $gespielte_wuensche ) ) : ?>
                <?php foreach ( $gespielte_wuensche as $wunsch ) : ?>
                    <tr>
                        <td><?php echo esc_html( get_the_modified_date( 'd.m.Y H:i', $wunsch ) ); ?> Uhr</td>
                        <td><strong><?php echo esc_html( get_post_meta( $wunsch->ID, '_dllw_sender_name', true ) ); ?></strong></td>
                        <td>
                            <strong><?php echo esc_html( $wunsch->post_title ); ?></strong>
                            <p><?php echo nl2br( esc_html( $wunsch->post_content ) ); ?></p>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else : ?>
                <tr>
                    <td colspan="3"><?php _e( 'Bisher wurden keine Wünsche als "gespielt" markiert.', 'deelaulab-wunschbox' ); ?></td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>