<!DOCTYPE html>
<html lang="de" data-bs-theme="dark">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Wunschbox</title>
    
    <meta http-equiv="refresh" content="60">

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-QWTKZyjpPEjISv5WaRU9OFeRpok6YctnYmDr5pNlyT2bRjXh0JMhjY6hW+ALEwIH" crossorigin="anonymous">

    <style>
        body { background-color: #212529; color: #dee2e6; }
        .card { background-color: #343a40; border-color: #495057; }
        .card-title { color: #fff; }
    </style>
</head>
<body class="py-4">

    <div class="container">
        <h1 class="mb-4 text-center">Aktive Wünsche</h1>

        <?php if ( ! empty( $wartende_wuensche ) ) : ?>
            <?php foreach ( $wartende_wuensche as $wunsch ) : ?>
                <?php
                    $token = esc_attr( $_GET['token'] );
                    $nonce = wp_create_nonce( 'dllw_widget_action_' . $wunsch->ID );
                    $url_gespielt = home_url( "/?deelaulab_widget=true&token={$token}&action=set_status_gespielt&wunsch_id={$wunsch->ID}&_wpnonce={$nonce}" );
                    $url_trash = home_url( "/?deelaulab_widget=true&token={$token}&action=trash&wunsch_id={$wunsch->ID}&_wpnonce={$nonce}" );
                ?>
                <div class="card mb-3">
                    <div class="card-body">
                        <div class="d-flex justify-content-between align-items-start">
                            <div>
                                <h5 class="card-title mb-1"><?php echo esc_html( $wunsch->post_title ); ?></h5>
                                <h6 class="card-subtitle mb-2">Von: <?php echo esc_html( get_post_meta( $wunsch->ID, '_dllw_sender_name', true ) ); ?></h6>
                            </div>
                            <span class="badge bg-secondary"><?php echo esc_html( get_post_status_object( $wunsch->post_status )->label ); ?></span>
                        </div>
                        
                        <p class="card-text mt-2"><?php echo nl2br( esc_html( $wunsch->post_content ) ); ?></p>
                        
                        <div class="mt-3">
                            <a href="<?php echo esc_url( $url_gespielt ); ?>" class="btn btn-success btn-sm">Gespielt</a>
                            <a href="<?php echo esc_url( $url_trash ); ?>" class="btn btn-danger btn-sm">Löschen</a>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php else : ?>
            <div class="alert alert-info" role="alert">
                Keine aktiven Wünsche vorhanden.
            </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js" integrity="sha384-YvpcrYf0tY3lHB60NNkmXc5s9fDVZLESaAA55NDzOxhy9GkcIdslK1eN7N6jIeHz" crossorigin="anonymous"></script>
</body>
</html>